// Ce code fonctionne comme prévu
int ledPinBlink  = 13; // LED clignotante rouge - broche 13
int ledPinButton = 10; // LED de bouton-poussoir jaune - broche 10
int buttonPin = 8;     // Bouton-poussoir - broche 8
int buttonState;       // Variable d'état du bouton
int interval = 2000;   // Intervalle de temps (2 secondes)
unsigned long prev;    // Variable de temps
int ledStatus = LOW;   // Variable d'état pour la LED clignotante

void setup() {
  pinMode(ledPinBlink, OUTPUT);  // Broche LED clignotante comme sortie
  pinMode(ledPinButton, OUTPUT); // Broche LED de bouton-poussoir comme sortie
  pinMode(buttonPin, INPUT);     // Broche du bouton-poussoir comme entrée
  prev = millis();               // Mémoriser le compteur de temps actuel
}

void loop() {
  // Faire clignoter la LED clignotante via la gestion des intervalles
  if((millis() - prev) > interval) {
    prev = millis();
    ledStatus = !ledStatus; // Bascule l'état de la LED
    digitalWrite(ledPinBlink, ledStatus); // Bascule la LED rouge
  }  
  // Interrogation de l'état du bouton-poussoir
  buttonState = digitalRead(buttonPin);
  if(buttonState == HIGH)
    digitalWrite(ledPinButton, HIGH); // LED jaune au niveau HIGH
  else
    digitalWrite(ledPinButton, LOW);  // LED jaune au niveau LOW
}
